<?php

namespace App\Http\Controllers\web\stock;

use App\models\stock\Warehouse;
use App\Http\Controllers\Controller;

class WarehouseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brunch = request()->user()->company;
        $warehouses = $brunch->warehouses;
        $data = compact(
            'warehouses'
        );
        return view('stock.warehouse.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('stock.warehouse.create.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Warehouse $warehouse)
    {
        $data = compact(
            'warehouse'
        );
        return view('stock.warehouse.show.index', $data);
    }
}
