<?php

namespace App\Http\Controllers\web\users;

use App\models\users\User;
use Illuminate\Http\Request;
use App\models\company\Brunch;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Symfony\Component\HttpFoundation\Response;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Brunch $brunch)
    {
        abort_if(Gate::denies('manage-users', $brunch), Response::HTTP_FORBIDDEN);
        $users = $brunch->users;
        $data = compact('users', 'brunch');
        return view('users.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Brunch $brunch)
    {
        $allow = false;
        $allow = Gate::allows('manage-users', $brunch);
        abort_if(!$allow, Response::HTTP_FORBIDDEN);
        $data = compact( 'brunch');
        return view('users.create.index', $data);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }


    public function myprofile(){
        $user = Auth::user();
        return $this->show($user->company, $user);
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Brunch $brunch, User $user)
    {
        $allow = false;
        $allow = Gate::allows('manage-users', $brunch);
        $allow = ($allow or request()->user()->is($user));
        $allow = $allow and $user->can('work-in', $brunch);
        abort_if(!$allow, Response::HTTP_FORBIDDEN);

        $data = compact('user', 'brunch');
        return view('users.show.index', $data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
