<?php

namespace App\Http\Livewire\Customer;

use Illuminate\Support\Arr;
use Carbon\Carbon;
use Livewire\Component;


class CustomerStatement extends Component
{

    public $customer, $from, $to, $general, $invoice_type, $delivery_type, $vds_type;
    public $deliver_notes = [], $invoice=[], $vds = [], $all = [];
    public $total_invoice = 0;

    public function mount($customer){

        $this->customer = $customer;

    }

    public function extract($data, $all_response){

        $datas = collect([]);
        $this->deliver_notes = [];
        $this->invoice = [];
        $this->vds = [];
        $this->all = [];

        foreach($data as $items){
            $datas->push((object)$items); // convertendo o array em objecto force...

        }

        foreach($datas as $item){


            if($item->type!='Proforma' && $item->type!='receipt'){
                array_push($this->all, $item);
                $this->general = 'geral';
            }

            if ($item->type=='deliveryNote') {
                array_push($this->deliver_notes, $item);
                $this->delivery_type = $item->type;
            }

            if ($item->type=='invoice') {
                array_push($this->invoice, $item);
                $this->invoice_type = $item->type;
            }


            if ($item->type=='cashSale') {
                array_push($this->vds, $item);
                $this->vds_type = $item->type;
            }
        }


      $reference =  Arr::get($all_response, 'reference');

      $from = Arr::get($reference, 'from');
      $to = Arr::get($reference, 'to');

      $this->from =  $from;
      $this->to =    $to;

    }


    function printInvoice(){

        $totalAmount = 0;

        $paidamount= 0;
        $pendingamount=0;

        foreach($this->invoice as $item){

            $total = floatval(Arr::get($item, 'totalamount'));

            $totalAmount+=$total;

            $paid = floatval(Arr::get($item, 'paidamount'));

            $credit = floatval(Arr::get($item, 'credit'));
            $pending = floatval(Arr::get($item, 'pendingamount'));
            $pendingamount+=$pending;


            if($paid==0){
                $paidamount+=$credit;
            } else {
                $paidamount+=$paid;
            }

        }
        return redirect()->signedRoute('web.customer.print', [
            'all'=>$this->invoice,
            'total'=>$totalAmount,
            'paidamount'=>$paidamount,
            'pendingamount'=>$pendingamount,
            'customer'=>$this->customer->id,
            'from_default'=>$this->from,
            'to_default'=>$this->to,
            'type'=>$this->invoice_type
        ]);
    }

    function printDelivery(){

        $totalAmount = 0;

        $paidamount= 0;
        $pendingamount=0;

        foreach($this->deliver_notes as $item){

            $total = floatval(Arr::get($item, 'totalamount'));

            $totalAmount+=$total;

            $paid = floatval(Arr::get($item, 'paidamount'));

            $credit = floatval(Arr::get($item, 'credit'));
            $pending = floatval(Arr::get($item, 'pendingamount'));
$pendingamount+=$pending;


            if($paid==0){
                $paidamount+=$credit;
            } else {
                $paidamount+=$paid;
            }

        }
        return redirect()->signedRoute('web.customer.print', [
            'all'=>$this->deliver_notes,
            'total'=>$totalAmount,
            'paidamount'=>$paidamount,
            'pendingamount'=>$pendingamount,
            'customer'=>$this->customer->id,
            'from_default'=>$this->from,
            'to_default'=>$this->to,
            'type'=>$this->delivery_type
        ]);
    }

    function printVds(){

        $totalAmount = 0;

        $paidamount= 0;
        $pendingamount=0;

        foreach($this->vds as $item){

            $total = floatval(Arr::get($item, 'totalamount'));

            $totalAmount+=$total;

            $paid = floatval(Arr::get($item, 'paidamount'));

            $credit = floatval(Arr::get($item, 'credit'));
            $pending = floatval(Arr::get($item, 'pendingamount'));
$pendingamount+=$pending;


            if($paid==0){
                $paidamount+=$credit;
            } else {
                $paidamount+=$paid;
            }

        }
        return redirect()->signedRoute('web.customer.print', [
            'all'=>$this->vds,
            'total'=>$totalAmount,
            'paidamount'=>$paidamount,
            'pendingamount'=>$pendingamount,
            'customer'=>$this->customer->id,
            'from_default'=>$this->from,
            'to_default'=>$this->to,
            'type'=>$this->vds_type
        ]);
    }


    function printGeneral(){

        $totalAmount = 0;
        $paidamount= 0;
        $pendingamount=0;

        foreach($this->all as $item){

            $total = floatval(Arr::get($item, 'totalamount'));

            $totalAmount+=$total;

            $paid = floatval(Arr::get($item, 'paidamount'));

            $credit = floatval(Arr::get($item, 'credit'));
            $pending = floatval(Arr::get($item, 'pendingamount'));
$pendingamount+=$pending;


            if($paid==0){
                $paidamount+=$credit;
            } else {
                $paidamount+=$paid;
            }

        }


        return redirect()->signedRoute('web.customer.print', [
            'all'=>$this->all,
            'total'=>$totalAmount,
            'paidamount'=>$paidamount,
            'pendingamount'=>$pendingamount,
            'customer'=>$this->customer->id,
            'from_default'=>$this->from,
            'to_default'=>$this->to,
            'type'=>$this->general
        ]);
    }





    public function render()
    {
        return view('livewire.customer.customer-statement');
    }
}
