<?php

namespace App\Http\Livewire\Expiredsaleable;

use App\models\stock\Saleable;
use App\models\stock\Warehouse;
use Livewire\Component;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Flasher\Toastr\Prime\ToastrFactory;

class Expiredsaleble extends Component
{
    public $date, $warehouses, $warehouse, $stockmoves = [];

    public function mount($warehouses){

        $this->warehouses = $warehouses;
    }


    public function checkExpiredSaleable(){

        $user = request()->user();
        $saleables = $user->brunch->saleables;
        $warehouses = $user ->brunch->warehouses;
        $stockmoves = collect([]);
        $warehouse  = collect();


          if ($this->warehouse==null) {
            $warehouse = $user->brunch->saleWarehouse();
           } else{
               $warehouse = Warehouse::find($this->warehouse);
           }

          foreach($saleables as $saleable){

              $lastmove  = $warehouse->ExpiredSaleables($saleable, $this->date);

              if($lastmove!=null){
                  $product = $lastmove->saleable;
                  $stockmoves->push((object)[
                      'id'       => $product->id,
                      'code'     =>$product->code,
                      'name'     =>$product->name,
                      'price'    =>$product->price,
                      'balance'  => $lastmove->balance,
                      'lastmove' =>$lastmove->quantity,
                      'movedate' =>date($lastmove->expirity_date)
                     ]
                  );
              }
          }


          $this->stockmoves = $stockmoves;


      }


    public function exportExcel(ToastrFactory $flasher)
    {
         if (empty($this->stockmoves)) {
             $flasher->addWarning('Preencha os campos', 'Ops');
         } else{
             return Excel::download(new StockExport($this->stockmoves), 'invenatrio.xlsx');
         }

    }

    public function render()
    {
        return view('livewire.expiredsaleable.expiredsaleble');
    }
}


class StockExport implements FromView, WithHeadings
{

    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function view(): View
    {


        return view('stock.stockmove.inventory.toolslist.expired_product.export_excel.excel', [
            'data' => $this->data,
        ]);
    }

    public function headings(): array
    {
        return [
            'id'       ,
            'code'     ,
            'price'    ,
            'name'     ,
            'balance'  ,
            'lastmove' ,
            'movedate' ,
        ];
    }
}
