<?php

namespace App\Http\Livewire\InvoiceByDeliveryNote;

use Carbon\Carbon;
use Livewire\Component;
use App\models\sales\Invoice;
use App\models\stock\Saleable;
use App\models\customers\Customer;
use App\models\sales\DeliveryNote;
use Flasher\Toastr\Prime\ToastrFactory;
use Flasher\Toastr\Laravel\Facade\Toastr;
use Symfony\Component\HttpFoundation\Response;
use App\models\sales\relation\ItemSaleableInvoiceByDelivery;
use Illuminate\Support\Facades\URL;

class InvoiceByDeliveryNote extends Component
{

    public $customers_id, $valor=0, $delivers_id = [], $obs = 'Baseada em Guias / By delivery', $show= false, $is_customer_changed=false;
    public $customerName,  $customerDelivery=[], $customerNuit, $total, $deliveryName = [], $deliveryNotesItems = [];
    public $re_render = false;


    public function onChangeCustomers(){

        $this->is_customer_changed=true; //para o js saber que a função changeCustomer foi usado
        $user = request()->user();
        $brunch = $user->company;
        $customer = $brunch->customers()->where('id', $this->customers_id)->first();

        $this->customerName = $customer->name;
        $this->customerNuit = $customer->nuit;

        $operations = $customer->customerOperations()->get();

        $this->customerDelivery = [];

        foreach($operations as $key => $op) {

               $delivery = $op ->deliveryNote()->where('invoiced', 0)->first();



                if ($delivery!=null) {

                    array_push($this->customerDelivery, $delivery->name());

                }else {
                    // $this->customerDelivery = [];

                }


         }




    }


    public function modal(){


        $user = request()->user();
        $brunch = $user->company;

        $subtotal =0;

        array_pop($this->deliveryName);

        //calcular o valor total das guias e pega os nomes

        foreach ($this->delivers_id as $key => $id) {

            $delivers =DeliveryNote::where('id', $id)->first();
            $subtotal = $subtotal + $delivers-> totalAmount();


            array_push($this->deliveryName, $delivers->name() );

            //Pegando todos os items das guias.

            // foreach ($delivers->saleItens()->get() as $key => $items) {

            //     array_push($this->deliveryNotesItems, $items);
            // }

            $saleableItem = $delivers->saleItens;

            foreach ($saleableItem as $key => $value) {
                // dd(is_object($value));
                array_push($this->deliveryNotesItems, $value);
            }




        }



        $this->show = true;
        $this->total = $subtotal;
        array_pop($this->customerDelivery);

    }


    public function fechar(){

        // $this->delivers_id = [];
        array_pop($this->delivers_id);
        array_pop( $this->deliveryName);
        $this->customers_id = null;
        $this->show = false;

    }

    public function finalizar_imprimir(){

        $id = 0;

        try {
              $id =  $this->finalizar();

        } catch (\Throwable $th) {
            //throw $th;
        }
        return redirect()->signedRoute('web.sales.invoices.print', ['invoice' => $id]);

    }

    public function finalizar(){

        $user = request()->user();
        $brunch = $user->company;

        $invoiceNullableNormal =  $brunch->invoices()->where('validated_at', null)->first();
        $invoice =  $brunch->invoicesbydelivery()->where('validated_at', null)->first();   // ultima fatura baseada em guia

        $last_Normal_invoice = $brunch->invoices()->where('validated_at', '!=', null)->latest('created_at')->first();
        $last_By_delivery_invoice = $brunch->invoicesbydelivery()->where('validated_at', '!=', null)->latest('created_at')->first();



        $updated_id = 0;

        if (is_object($last_By_delivery_invoice) && is_object($last_Normal_invoice)) {

            if ($last_By_delivery_invoice->counter > $last_Normal_invoice->counter ) {

                $updated_id =  $last_By_delivery_invoice->counter + 1;
            }else {
                $updated_id = $last_Normal_invoice->counter + 1;
            }
        }

        if ($last_By_delivery_invoice == null && $last_Normal_invoice != null) {

                $updated_id =  $last_Normal_invoice->id + 1;
            }


        $customer = Customer::find($this->customers_id);
        $invoice->obs=$this->obs;
        $invoice->financial_discount    = 0;
        $invoice->due_date              = (new Carbon())->addMonth();

        if ($updated_id == 0) {
            $invoice->code = 'F.'.$invoice->id.'.'.(new Carbon($invoice->validated_at))->format("Y");
            $invoice->counter = $invoice ->id;
         } else {
            $invoice->counter = $updated_id;
            $invoice->code = 'F.'.$updated_id.'.'.(new Carbon($invoice->validated_at))->format("Y");
         }

        $invoice->validate($customer);
        $invoice->deliveryNotes()->sync($this->delivers_id); //vinculando as guias a factura que pretende-se emitir






        $item =  new ItemSaleableInvoiceByDelivery();  // nova instancia

        foreach ($this->delivers_id as $key => $id) {

            $delivers =DeliveryNote::where('id', $id)->first();

            $delivers->update([
                'invoiced' => 1
            ]);


            //Pegando todos os items das guias.

            $saleableItem = $delivers->saleItens;

            foreach ($saleableItem as $key => $itemm) {

                $item->create([
                    'invoicesbydelivery_id' => $invoice->id,
                    'saleable_id' => $itemm->saleable_id,
                    'sale_code' => $itemm->sale_code,
                    'sale_name' => $itemm->sale_name,
                    'quantity' => $itemm->quantity,
                    'unit_amount' => $itemm->unit_amount,
                    'discount' => $itemm->discount,
                    'vat_tax' => $itemm->vat_tax,
                ]);


            }

        }


        $this->show = false;
        $this->re_render = true;
        toastr()->success('Finalizado');
        $user = request()->user();
        $user->createInvoiceByDeliveryNotes();



        $last = $brunch->invoicesbydelivery()->where('validated_at', '!=', null)->latest('created_at')->first();

        return $last->id;

    }




    public function render()
    {
        $user = request()->user();
        $brunch = $user->company;




        $customers = $brunch->customers()
            ->where('default', false)
            ->orWhere('default', 0)
            ->orWhere('default', null)
            ->with(['invoices' => function($query){
                return $query
                    ->whereNotNull(Invoice::table().'.validated_at')
                    ->doesntHave('creditNotes')
                    ->doesnthave('receipts');
            }])
            ->get();

        $delivers = $brunch->deliveryNotes()->where('validated_at', '!=', null)->where('invoiced', 0)->orderBy('id', 'DESC')->get();

        $data = compact(
            'customers',
            'delivers'
        );

        return view('livewire.invoice-by-delivery-note.invoice-by-delivery-note', $data);
    }
}
