<?php

namespace App\Http\Livewire\StockAlert;

use App\models\stock\Saleable;
use App\models\stock\Warehouse;
use Livewire\Component;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Flasher\Toastr\Prime\ToastrFactory;

class StockAlert extends Component
{
    public $condition="<", $qty, $warehouse, $warehouses, $stockmoves = [];

    public function mount($warehouses){

        $this->warehouses = $warehouses;
    }

    public function updateStock(){

      $user = request()->user();
      $saleables = $user->brunch->saleables;
      $warehouses = $user ->brunch->warehouses;
      $stockmoves = collect([]);
      $warehouse  = collect();


        if ($this->warehouse==null) {
          $warehouse = $user->brunch->saleWarehouse();
         } else{
             $warehouse = Warehouse::find($this->warehouse);
         }

        foreach($saleables as $saleable){

            $lastmove  = $warehouse->lastMoveByQty($saleable, $this->condition, $this->qty);

            if($lastmove!=null){
                $product = $lastmove->saleable;
                $stockmoves->push((object)[
                    'id'       => $product->id,
                    'code'     =>$product->code,
                    'name'     =>$product->name,
                    'price'    =>$product->price,
                    'balance'  => $lastmove->balance,
                    'lastmove' =>$lastmove->quantity,
                    'movedate' =>date($lastmove->created_at)
                   ]
                );
            }
        }


        $this->stockmoves = $stockmoves;


    }

    public function exportExcel(ToastrFactory $flasher)
   {
        if (empty($this->stockmoves)) {
            $flasher->addWarning('Preencha os campos', 'Ops');
        } else{
            return Excel::download(new StockExport($this->stockmoves, $this->condition, $this->qty), 'invenatrio.xlsx');
        }


   }

    public function render()
    {
        return view('livewire.stock-alert.stock-alert');
    }
}

class StockExport implements FromView, WithHeadings
{

    private $data, $condition, $qty;

    public function __construct($data, $condition, $qty)
    {
        $this->data = $data;
        $this->condition = $condition;
        $this->qty = $qty;
    }

    public function view(): View
    {
     

        return view('stock.stockmove.inventory.toolslist.stockbyqty.export_excel.excel', [
            'data' => $this->data,
            'condition' =>$this->condition,
            'qty'       =>$this->qty
        ]);
    }

    public function headings(): array
    {
        return [
            'id'       ,
            'code'     ,
            'price'    ,
            'name'     ,
            'balance'  ,
            'lastmove' ,
            'movedate' ,
        ];
    }
}


