<?php

namespace App\Http\Livewire\Tempsaleables;

use App\models\stock\Saleable;
use Livewire\Component;
use App\models\stock\VatScheme;

class Tempsaleables extends Component
{


    public $data = [], $search='';
    public $name, $code, $price, $vat, $unit,
     $is_stockable=false, $description,
      $categories_temp = [], $temp_id;




    public function remover($id){
        $brunch = request()->user()->company;
        $temp = $brunch->saleables()->onlyTrashed()->where('id', $id)->forceDelete();

    }



    public function finalizar(){

        $brunch = request()->user()->company;
        $temp_saleables = $brunch->saleables()->where('temp', 1)->onlyTrashed()->get();

        foreach ($temp_saleables as $key => $item) {
            $item->update([
                'temp'=>0,
            ]);

            $brunch->saleables()->onlyTrashed()->where('id', $item->id)->restore();

        }
    }

    public function cancelar(){

        $brunch = request()->user()->company;
        $temp_saleables = $brunch->saleables()->where('temp', 1)->onlyTrashed()->get();

        foreach ($temp_saleables as $key => $trashedsaleable) {

            $brunch->saleables()->onlyTrashed()->where('id', $trashedsaleable->id)->forceDelete();

            if ($key==$temp_saleables->count()) {
                $this->data='ALl delete';
            }
        }



    }


    public function editar($id){

        $brunch = request()->user()->company;
        $temp = $brunch->saleables()->onlyTrashed()->where('id', $id)->first();

        $this->temp_id = $temp->id;
        $this->name = $temp->name;
        $this->code = $temp->code;
        $this->price = $temp->price;
        $this->vat =  $temp->vat_scheme_id;
        $this->unit = $temp->sale_units_id;
        $this->is_stockable = $temp -> is_stockable;
        $this->description = $temp -> description;


    }




    public function update(){

        $brunch = request()->user()->company;
        $brunch->saleables()->onlyTrashed()
        ->where('temp', 1)->where('id', $this->temp_id)
        ->update([
            'name' => $this->name,
            'code' => $this->code,
            'price' => $this->price,
            'vat_scheme_id' => $this->vat,
            'sale_units_id' => $this->unit,
            'is_stockable'  => $this->is_stockable,
            'description'   => $this->description
        ]);
    }


    public function render()
    {
        $brunch = request()->user()->company;
        $temp_saleables = $brunch->saleables()->where('temp', 1)->onlyTrashed()
        ->where('name', 'like', '%'.$this->search.'%')
        ->orderBy('id','ASC')->paginate();



        $saleunits = $brunch->saleUnits;
        $vatschemes = VatScheme::all();
        $categories = $brunch->categories;


        $data = compact(
            'saleunits',
            'categories',
            'vatschemes',
            'temp_saleables'
        );


        return view('livewire.tempsaleables.tempsaleables', $data);
    }
}
