<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReportGeneratorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "documents" => 'required|array|',
            "documents.*" => 'required|integer|in:1,2,3,4,5,6,7,8',
            "period_from" => 'required|date|before_or_equal:today',
            "period_to" => 'required|date',
            "type" => 'nullable|in:json,pdf'
        ];
    }
}

