<?php

namespace App\Http\Requests\company;

use Illuminate\Foundation\Http\FormRequest;

class BrunchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'      => 'bail|required|string|min:3',
            'country'   => 'bail|required|string|min:3',
            'city'      => 'bail|required|string|min:3',
            'address'   => 'bail|required|string|min:3',
            'phone'     => 'bail|required|string|min:3',
            'email'     => 'bail|required|email|string|min:3',
            'nuit'      => 'bail|required|string|min:3',
            'daf_auth'      => 'bail|nullable|string|min:3',
            'bank_data_footer'      => 'bail|nullable|string',
            'vat_scheme'=> 'bail|required|exists:company_vat_scheme,id',
            'funcionalities' => 'bail|nullable|array',
            'funcionalities.*' => 'exists:system_funcionalities,id'
        ];
    }
}
