<?php

namespace App\Http\Requests\company\crm;

use Illuminate\Foundation\Http\FormRequest;

class CRMConfigurationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'enable' =>            'bail|required_without_all:increment_amount,point_amount|in:true,1,on',
            'increment_amount' =>   'bail|required|numeric|min:0',
            'point_amount' =>       'bail|required|numeric|min:0'
        ];
    }
}
