<?php

namespace App\Http\Requests\customers;

use Illuminate\Foundation\Http\FormRequest;

class BillsSearchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'customer' => 'bail|required|numeric|exists:customers,id',
            'amount' => 'bail|nullable|numeric|min:0',
        ];
    }
}
