<?php

namespace App\Http\Requests\customers;

use Illuminate\Foundation\Http\FormRequest;

class CustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nuit'          => 'bail|required_without:file|min:3',
            'name'          => 'bail|required_without:file|string|min:3',
            'phone'   => 'bail|nullable|string|min:3',
            'address'   => 'bail|nullable|string|min:3',
            'discount'  => 'bail|nullable|numeric|min:0|max:100',
            'file'          => 'bail|required_without_all:code,name,description,is_stockable,min_quantity,price,sale_unit,vat_scheme,categories|file|mimes:xls,xlsx'
        ];
    }
}
