<?php
namespace App\Http\Requests\reports;


use Illuminate\Foundation\Http\FormRequest;

class GeneralSalesReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'from'  => 'nullable|required_with:to|date|before_or_equal:today',
            'to'    => 'nullable|required_with:from|date',
            'take'  => 'nullable|integer|min:1',
        ];
    }
}
