<?php

namespace App\Http\Requests\sales;

use App\models\sales\utils\PaymentMethod;
use Illuminate\Foundation\Http\FormRequest;

class CashSaleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'payment_method'    => 'bail|required|exists:payment_methods,id|not_in:'.PaymentMethod::crmpoints()->id,
            'discount'          => 'bail|nullable|numeric|min:0',
            'customer'          => 'bail|required|exists:customers,id',
            'bank_name'         => 'bail|required_if:payment_method,'.PaymentMethod::bankcheck().'|required_if:payment_method,'.PaymentMethod::banktransfer().'|nullable|string|min:2',
            'bank_document_nr'  => 'bail|required_if:payment_method,'.PaymentMethod::bankcheck().'|required_if:payment_method,'.PaymentMethod::banktransfer().'|nullable|string|min:2',

            'customer_name'     => 'bail|nullable|string',
            'customer_vat'      => 'bail|nullable|string',
            'customer_address'  => 'bail|nullable|string',

        ];
    }
}
