<?php

namespace App\Http\Requests\sales;

use Illuminate\Foundation\Http\FormRequest;

class DebitNoteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'financial_discount'    => 'bail|nullable|numeric|min:0',
            'invoice'               => 'bail|required_without:customer|nullable|integer|exists:invoices,id',
            'customer'              => 'bail|required_without:invoice|nullable|integer|exists:customers,id',
        ];
    }
}
