<?php

namespace App\Http\Requests\sales;


use Illuminate\Foundation\Http\FormRequest;

class InvoicableRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'take'          => 'nullable|integer|min:1',
            'page'          => 'nullable|integer|min:1',

            'date_from'     => 'nullable|date',
            'date_to'       => 'nullable|date',

            'paid'          => 'nullable|in:on,true,1',
            'canceled'      => 'nullable|in:on,true,1',
            'delayed'       => 'nullable|in:on,true,1',

            'payment_method' => 'nullable|integer|exists:payment_methods,id',

            'customers'     => 'nullable|array',
            'customers.*'   => 'integer|exists:customers,id',

            'employee'      => 'nullable|integer|exists:users,id',
            'shift'         => 'nullable|integer|exists:shifts,id',

        ];
    }
}
