<?php

namespace App\Http\Requests\sales;

use Illuminate\Foundation\Http\FormRequest;

class InvoiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'customer'  => 'bail|required|exists:customers,id',
            'discount'  => 'bail|nullable|numeric|min:0',
            'due_date'  => 'bail|nullable|date|after_or_equal:today',
            'obs'       => 'bail|nullable|string'
        ];
    }
}
