<?php

namespace App\Http\Requests\sales;

use Illuminate\Foundation\Http\FormRequest;

class ProformaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'financial_discount'    => 'bail|nullable|numeric|min:0',
            'customer'              => 'bail|nullable|exists:customers,id',
            'customer_name'         => 'bail|required_without:customer|nullable|string',
            'customer_nuit'         => 'bail|required_without:customer|nullable|string',
            'customer_address'      => 'bail|required_without:customer|nullable|string',
            'obs'                   => 'bail|nullable|string',
            'due_date'  => 'bail|nullable|date|after_or_equal:today',
        ];
    }
}
