<?php

namespace App\Http\Requests\sales;

use App\models\sales\utils\PaymentMethod;
use Illuminate\Foundation\Http\FormRequest;

class ReceiptRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $check      = PaymentMethod::bankcheck()->id;
        $transfer   = PaymentMethod::banktransfer()->id;
        $crm        = PaymentMethod::crmpoints()->id;

        return [
            'payment_method'        => 'bail|required|not_in:'.$crm.'|exists:payment_methods,id',
            'amount'                => 'bail|nullable|numeric|min:0',
            'bank_name'             => 'bail|required_if:payment_method,'.$check.'|required_if:payment_method,'.$transfer.'|nullable|string|min:2',
            'bank_document_nr'      => 'bail|required_if:payment_method,'.$check.'|required_if:payment_method,'.$transfer.'|nullable|string|min:2',
            'items'                 => 'bail|required|array',
            'items.*'              =>  'bail|required|string',
            'obs'                   => 'bail|nullable|string'
        ];
    }

    /*
        'items'                 => 'bail|required|array',
        'items.id'              => 'bail|required|numeric',
        'items.type'            => 'bail|required|numeric|in:1,2',
    */
}