<?php

namespace App\Http\Requests\sales\relation;

use Illuminate\Foundation\Http\FormRequest;

class ItemReciptRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'invoice'    => 'bail|required_without:debit_note',
            'debit_note' => 'bail|required_without:invoice',
            'amount'     => 'bail|required|numeric|min:3',
        ];
    }
}
