<?php

namespace App\Http\Requests\sales\relation;

use Illuminate\Foundation\Http\FormRequest;

class ItemSalableBasicRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type'          => 'bail|nullable|in:normal,fast',
            'saleable'      => 'bail|required_if:type,fast|exists:saleable,id',

            'sale_code'     => 'bail|required_if:type,normal|string|min:1',
            'sale_name'     => 'bail|required_if:type,normal|string|min:1',
            'quantity'      => 'bail|required|numeric|min:0.00000001',
            'unit_amount'   => 'bail|required_if:type,normal|numeric|min:0',
            'discount'      => 'bail|required_if:type,normal|numeric|min:0',
            'vat_tax'       => 'bail|nullable|numeric|min:0',
        ];
    }
}
