<?php

namespace App\Http\Requests\sales\relation;

use Illuminate\Foundation\Http\FormRequest;

class ItemSalableInvoiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'saleable'      => 'bail|nullable|exists:saleable,id',
            'warehouse'      => 'bail|nullable|exists:warehouses,id',

            'sale_code'     => 'bail|required_without:saleable|string|min:1',
            'sale_name'     => 'bail|required_without:saleable|string|min:1',
            'quantity'      => 'bail|required|numeric|min:0.00000001',
            'unit_amount'   => 'bail|required|numeric|min:0',
            'discount'      => 'bail|nullable|numeric|min:0',
            'vat_tax'       => 'bail|nullable|numeric|min:0',
        ];
    }
}
