<?php

namespace App\Http\Requests\stock;

use Illuminate\Foundation\Http\FormRequest;

class SaleableRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'code'                  => 'bail|required_without:file|min:3',
            'name'                  => 'bail|required_without:file|string|min:3',
            'description'           => 'bail|nullable|string|min:3',
            'stockable'             => 'bail|nullable|in:true,false,in,on,1,0',

            'calculate_vat_scheme'   => 'bail|nullable|in:true,false,in,on,1,0',

            'min_quantity'          => 'bail|nullable|numeric|min:0',
            'price'                 => 'bail|required_without:file|numeric|min:0',
            'sale_unit'             => 'bail|required_without:file|exists:sale_units,id',
            'vat_scheme'            => 'bail|required_without:file|exists:vat_scheme,id',
            'categories'            => 'bail|nullable|array',
            'categories.*'          => 'bail|required_without:file|exists:category,id',
            'file'                  => 'bail|required_without_all:code,name,description,is_stockable,min_quantity,price,sale_unit,vat_scheme,categories|file|mimes:xls,xlsx'
        ];
    }
}
