<?php

namespace App\Http\Requests\stock;

use Illuminate\Foundation\Http\FormRequest;

class StockMoveFilterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'warehouse' => 'bail|required|integer|exists:warehouses,id',
            'categories' => 'bail|nullable|array',
            'categories.*' => 'integer|exists:category,id'
        ];
    }
}
