<?php

namespace App\Http\Requests\stock;

use Illuminate\Foundation\Http\FormRequest;

class StockMoveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'saleable'  => 'bail|required_without:file|exists:saleable,id',
            'quantity'  => 'bail|required_without:file|numeric|min:0',
            'price'     => 'bail|required_without:file|numeric|min:0',
            'expirity_date' => 'bail|nullable|date|after:today',
            'warehouse'     => 'bail|required_without:file|exists:warehouses,id',
            // 'provider'      => 'bail|required_without:file|exists:providers,id',

            'purchase'      => 'bail|nullable|integer|exists:purchases,id',
            'file'          => 'bail|required_without_all:code,name,description,is_stockable,min_quantity,price,sale_unit,vat_scheme,categories|file|mimes:xls,xlsx'
        ];
    }
}
