<?php
namespace App\Http\Requests\stock\transference;


use Illuminate\Foundation\Http\FormRequest;

class TransferenceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'saleable'  => 'bail|required|exists:saleable,id',
            'quantity'  => 'bail|required|numeric|min:0',
            'warehouse_from'    => 'bail|required|exists:warehouses,id',
            'warehouse_to'      => 'bail|required|exists:warehouses,id',
        ];
    }
}
