<?php

namespace App\Http\Requests\users;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'      => 'bail|required_without_all:roles,password|string|min:3',
            'email'     => ['bail','required_without_all:roles,password','email', Rule::unique('users')->ignore($this->user, 'id')],

            'roles'     => 'bail|nullable|required_without_all:name,email,password|array',
            'roles.*'   => 'exists:roles,id',

            'password'  => 'bail|required_without_all:name,email,roles|string|min:8|confirmed'
        ];
    }
}
