<?php

namespace App\Http\Resources\customers;

use Illuminate\Http\Resources\Json\ResourceCollection;

class CustomerCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = $this->collection;
        $data->transform(function ($item) {
            return [
                'id' => $item->id,
                'code' => $item->code,
                'name' => $item->name,
                'nuit' => $item->nuit,
                'phone' => $item->phone,
                'address' => $item->address,
                'discount' => $item->discount,
                'advance' => $item->availableAdvanceAmount(),
                'crm' => [
                    'points' => $item->availableCRMPoints(),
                    'amount' => $item->availableCRMAmount()
                ]
            ];
        });
        return $data->toArray();
    }
}
