<?php

namespace App\Http\Resources\customers;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\ResourceCollection;

class CustomerOperationResourceCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = $this->collection->map(function ($value, $key) {

            return [
                'id'        => $value->id,
                'date'      => $value->validated_at->format('d/m/Y H:i'),
                'name'      => $value->name(),
                'type'      =>$value->type(),
                'credit'    => $value->creditAmount(),
                'debit'     => number_format($value->debitAmount(), 2),
                'balance'   => number_format($value->postBalance(), 2),
                'totalamount' =>$value->totalAmount(),
                'paidamount'  =>$value->paidAmount(),
                'pendingamount' =>$value->pendingAmount(),
                'links' => [
                    'web' => $value->webLink()
                ]
            ];
        });
        return $data->toArray();
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'reference' => [
                'from'  => (new Carbon($request->input('from')))->format('d/m/Y'),
                'to'    => (new Carbon($request->input('to')))->format('d/m/Y'),
            ],
            'balance' => [
                'opening'   => $this->collection->first() ? $this->collection->first()->preBalance() : 0,
                'final'     => $this->collection->last() ? $this->collection->first()->postBalance() : 0,
            ]
        ];
    }
}
