<?php

namespace App\Http\Resources\models\provider;


use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\JsonResource;

class ExpenseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'description' => $this->description,
            'reference' => $this->reference,
            'validated_at' => $this->validated_at ? $this->validated_at->format('Y/m/d') : '',
            'anuled_at' => $this->anuled_at ? $this->anuled_at->format('Y/m/d') : '',
            'total_amount' => number_format($this->totalAmount(), 2),
            'url' => [
                'web' => URL::route('web.stock.providers.expenses.show', ['provider' => $this->provider->id, 'expense' => $this->id]),
                'api' =>  URL::route('api.stock.providers.expenses.show', ['provider' => $this->provider->id, 'expense' => $this->id]),
            ]
        ];
    }
}
