<?php

namespace App\Http\Resources\models\provider;

use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\stock\StockMoveCollection;

class PurchaseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'financial_discount' => $this->financial_discount,
            'validated_at' => $this->validated_at ? $this->validated_at->format('Y/m/d') : '',
            'anuled_at' => $this->anuled_at ? $this->anuled_at->format('Y/m/d') : '',
            'total_amount' => number_format($this->totalAmount(), 2),
            'moves' => new StockMoveCollection($this->stockMoves),
            'url' => [
                'web' => URL::route('web.stock.providers.purchases.show', ['provider' => $this->provider->id, 'purchase' => $this->id]),
                'api' =>  URL::route('api.stock.providers.purchases.show', ['provider' => $this->provider->id, 'purchase' => $this->id]),
            ]
        ];
    }
}
