<?php

namespace App\Http\Resources\sales;

use Carbon\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\ResourceCollection;

class BasicCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = $this->collection;

        $data->transform(function ($item, $key) {

            $customer = null;
            $validated = null;

            if ($item->isValid()) {
                $customer = [
                    'id' => $item->customerOperation ? $item->customerOperation->customer->id : 0,
                    'name' => $item->customer_name,
                    'nuit' => $item->customer_nuit,
                    'code' => $item->customer_address,
                ];
                $validated = (new Carbon($item->validated_at))->format('d/m/Y H:i');
            }
            $basic = $item;

            return [
                'id' => $item->id,
                'document' => $item->name(),
                'sequence' => $item->document_sequence,
                'financial_discount' => $item->financial_discount,
                'customer' => $customer,
                'validated_at' => $validated,
                'total_amount' => $item->totalAmount(),
                'links' => [
                    'web'   => URL::route('web.sales.basic.show', ['basic'=> $basic->id]),
                    'api'   => URL::route('api.sales.basic.show', ['basic'=> $basic->id]),
                    'self'  => URL::route('web.sales.basic.show', ['basic'=> $basic->id]),
                    'print' => URL::route('web.sales.basic.print', ['basic'=> $basic->id])
                ]
            ];
        });
        return [
            'data' => $data,
        ];
    }
}
