<?php

namespace App\Http\Resources\sales;

use Carbon\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\JsonResource;

class CashSaleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $customer = null;
        $validated = null;

        if ($this->isValid()) {
            $customer = [
                'id' => $this->customerOperation? $this->customerOperation->customer->id : 0,
                'name' => $this->customer_name,
                'nuit' => $this->customer_nuit,
                'code' => $this->customer_address,
            ];
            $validated = (new Carbon($this->validated_at))->format('d/m/Y H:i');
        }


        $cashsale = $this;
        $total = $this->totalAmount();


        $items = $this->saleItens->transform(function ($item) use ($cashsale) {
            return [
                'name' => $item->sale_name,
                'code' => $item->sale_code,
                'quantity' => $item->quantity,
                'unit_amount' =>  number_format($item->unit_amount, 2),
                'discount' => number_format($item->discount, 2),
                'total' => number_format($item->totalAmount(), 2),
                'links' => [
                    'self' => URL::route('api.sales.cashsale.item.destroy', ['cashsale' => $cashsale->id, 'item' => $item->id])
                ]
            ];
        });

        return [
            'id' => $this->id,
            'document' => $this->name(),
            'sequence' => $this->document_sequence,
            'financial_discount' => $this->financial_discount,
            'customer' => $customer,
            'validated_at' => $validated,
            'total_amount' => $total,
            'items' => $items,
            'links' => [
                'web'   => URL::route('web.sales.cashsale.show', ['cashsale'=> $cashsale->id]),
                'api'   => URL::route('api.sales.cashsale.show', ['cashsale'=> $cashsale->id]),
                'self'  => URL::route('web.sales.cashsale.show', ['cashsale'=> $cashsale->id]),
                'print' => URL::route('web.sales.cashsale.print', ['cashsale'=> $cashsale->id])
            ]
        ];
    }
}
