<?php

namespace App\Http\Resources\sales;

use Carbon\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\ResourceCollection;

class DeliveryNoteCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        $data = $this->collection;

        $data->transform(function ($item, $key) {

            $customer = null;
            $validated = null;
            $due = null;


            if ($item->isValid()) {
                $customer = [
                    'id' => $item->customerOperation ? $item->customerOperation->customer->id : 0,
                    'name' => $item->customer_name,
                    'nuit' => $item->customer_nuit,
                    'code' => $item->customer_address,
                ];
                $validated = (new Carbon($item->validated_at))->format('d/m/Y H:i');
                $due = $item->due_date->format('d/m/Y');
            }


            $invoice = $item->invoices->first();
            $paid = 0;
            $invoiced =0;

            if ($invoice!=null) {
                $paid = $invoice->paidAmount();
                $invoiced = $invoice->totalAmount();
            }


            $deliveryNote = $item;
            return [
                'id' => $item->id,
                'document' => $item->name(),
                'sequence' => $item->document_sequence,
                'financial_discount' => $item->financial_discount,
                'customer' => $customer,
                'validated_at' => $validated,
                'due_date' => $due,
                'invoiced' => $invoiced,  //total facturado
                'recipt'   =>$paid,       //total pago
                'total_amount' => $item->totalAmount(),
                'links' => [
                    'web'   => URL::route('web.sales.delivery_note.show', ['delivery_note' => $deliveryNote->id]),
                    'api'   => URL::route('api.sales.delivery_note.show', ['delivery_note' => $deliveryNote->id]),
                    'self'  => URL::route('web.sales.delivery_note.show', ['delivery_note' => $deliveryNote->id]),
                    'print' => URL::route('web.sales.delivery_note.print', ['delivery_note' => $deliveryNote->id])
                ]
            ];
        });
        return [
            'data' => $data,
        ];
    }
}
