<?php

namespace App\Http\Resources\sales;

use Illuminate\Http\Resources\Json\ResourceCollection;

class GeneralSaleCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = $this->collection->map(function ($item, $key) {
            $amount = $item->totalAmount();
            $pending = $item->pendingAmount();

            $tipo = 'F';
            $fatura = 'Fatura';

            if ($item->name()=='FG') {
               $tipo = 'FG';
               $fatura = 'Fatura/G';
            }

            return [
                'id'        => $item->id,
                'name'      => $item->code,
                'type'      => $item->isInvoice() ? __($fatura) : __('Nota de débito'),
                'hash'      => $item->isInvoice() ? $tipo.'-' . $item->id : 'N-' . $item->id,
                'amount'    => number_format($amount, 2),
                'amount_unformated'    => $amount,
                'pending'   => number_format($pending, 2),
                'pending_unformated' => $pending,
            ];
        });
        return $data->toArray();
    }
}
