<?php

namespace App\Http\Resources\sales;

use Carbon\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\JsonResource;

class InvoiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $customer = null;
        $validated = null;
        $due = null;

        if ($this->isValid()) {
            $customer = [
                'id' => $this->customerOperation ? $this->customerOperation->customer->id : 0,
                'name' => $this->customer_name,
                'nuit' => $this->customer_nuit,
                'code' => $this->customer_address,
            ];
            $validated = (new Carbon($this->validated_at))->format('d/m/Y H:i');
            $due = $this->due_date->format('d/m/Y');
        }

        $total = $this->totalAmount();


        $invoice = $this;


        $items = $this->saleItens->transform(function ($item) use ($invoice) {
            return [
                'name' => $item->sale_name,
                'code' => $item->sale_code,
                'quantity' => $item->quantity,
                'unit_amount' =>  number_format($item->unit_amount, 2),
                'discount' => number_format($item->discount, 2),
                'total' => number_format($item->totalAmount(), 2),
                'links' => [
                    'self' => URL::route('api.sales.invoice.item.destroy', ['invoice' => $invoice->id, 'item' => $item->id])
                ]
            ];
        });

        return [
            'id' => $this->id,
            'document' => $this->name(),
            'sequence' => $this->document_sequence,
            'financial_discount' => $this->financial_discount,
            'customer' => $customer,
            'validated_at' => $validated,
            'due_date' => $due,
            'total_amount' => $total,
            'items' => $items,
            'links' => [
                'self' => '',
                'print' => URL::route('web.sales.invoice.print', ['invoice' => $invoice->id])
            ]
        ];
    }
}
