<?php

namespace App\Http\Resources\stock;

use Illuminate\Http\Resources\Json\ResourceCollection;

class SaleableCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->transform(function ($item) {
            return [
                'id' => $item->id,
                'name' => $item->name,
                'price' => $item->price,
                'code' => $item->code,
                'description' => $item->description,
                'is_stockable' => $item->is_stockable ? true : false,
                'min_quantity' => $item->min_quantity,
                'unit' => $item->saleUnit->name,
                'vat' => [
                    'name' => $item->vatScheme->name,
                    'tax' => $item->vatScheme->tax,
                ],
                'sales' => $item->sales,
            ];
        })->toArray();
    }
}
