<?php

namespace App\Http\Resources\stock;

use Carbon\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\ResourceCollection;

class StockMoveCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = $this->collection;

        $data->transform(function ($item, $key) {

            $coast = $item->price * $item->balance;
            return [
                'id'            => $item->id,
                'quantity'      => $item->quantity,
                'balance'       => $item->balance,
                'price'         => number_format(abs($item->quantity * $item->unit_price), 2),


                'expirity_date' => (new Carbon($item->expirity_date))->format('m/d/Y'),
                'validated_at'  => $item->validated_at ? (new Carbon($item->validated_at))->format('m/d/Y') : null,
                'saleable'      => $item->saleable->name,
                'code'          => $item->saleable->code,
                'description'   => $item->saleable->description,
                'price'         => $item->saleable->price,
                'warehouse'     => $item->warehouse->name,
                'user'          => $item->user->name,
                'coast'         => $item->coast,
                'links' => [
                    'self' => URL::route('api.stock.move.destroy', ['move' => $item->id])
                ]
            ];
        });
        return  $data;
    }
}
