<?php

namespace App\Http\Resources\stock;

use Carbon\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\Resources\Json\JsonResource;

class StockMoveResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'quantity'      => $this->quantity,
            'balance'       => $this->balance,

            'price'         => number_format(abs($this->quantity * $this->unit_price), 2),
            'expirity_date' => (new Carbon($this->expirity_date))->format('m/d/Y'),
            'validated_at'  => $this->validated_at ? (new Carbon($this->validated_at))->format('m/d/Y') : null,
            'saleable'      => $this->saleable->name,
            'warehouse'     => $this->warehouse->name,
            'user'          => $this->user->name,
            'links' => [
                'self' => URL::route('api.stock.move.destroy', ['move' => $this->id])
            ]
        ];
    }
}
