<?php

namespace App\Http\Resources\stock\transference;

use Illuminate\Support\Facades\URL;
use App\Http\Resources\stock\StockMoveResource;
use Illuminate\Http\Resources\Json\ResourceCollection;

class TransferCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->transform(function ($item) {
            return [
                'id'    => $item->id,
                'user' => $item->group->user->name,
                'saleable' => $item->stockMoveFrom->saleable->name,
                'from'  => new StockMoveResource($item->stockMoveFrom),
                'to'    => new StockMoveResource($item->stockMoveTo),
                'links' => [
                    'self' => URL::route('api.stock.groups.transfers.destroy', ['group' => $item->group->id, 'transfer' => $item->id])
                ]
            ];
        });
    }
}
