<?php

namespace App\Http\Resources\stock\transference;

use Illuminate\Http\Resources\Json\JsonResource;

class TransferGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'validated_at' => $this->validated_at? $this->validated_at->format('Y-m-d H:i'): null,
            'user' => $this->user->name,
            'transfers' => new TransferCollection($this->transfers),
        ];
    }
}
