<?php

namespace App\Policies\company\crm;

use App\models\users\User;
use App\models\company\SystemFuncionality;
use App\models\company\crm\CRMConfiguration;
use Illuminate\Auth\Access\HandlesAuthorization;

class CRMConfigurationPolicy
{
    use HandlesAuthorization;

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::crm());
    }


    /**
     * Determine whether the user can view any c r m configurations.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the c r m configuration.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\company\crm\CRMConfiguration  $cRMConfiguration
     * @return mixed
     */
    public function view(User $user, CRMConfiguration $cRMConfiguration)
    {
        //
    }

    /**
     * Determine whether the user can create c r m configurations.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the c r m configuration.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\company\crm\CRMConfiguration  $cRMConfiguration
     * @return mixed
     */
    public function update(User $user, CRMConfiguration $cRMConfiguration)
    {
        //
    }

    /**
     * Determine whether the user can delete the c r m configuration.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\company\crm\CRMConfiguration  $cRMConfiguration
     * @return mixed
     */
    public function delete(User $user, CRMConfiguration $cRMConfiguration)
    {
        //
    }

    /**
     * Determine whether the user can restore the c r m configuration.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\company\crm\CRMConfiguration  $cRMConfiguration
     * @return mixed
     */
    public function restore(User $user, CRMConfiguration $cRMConfiguration)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the c r m configuration.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\company\crm\CRMConfiguration  $cRMConfiguration
     * @return mixed
     */
    public function forceDelete(User $user, CRMConfiguration $cRMConfiguration)
    {
        //
    }
}
