<?php

namespace App\Policies\customers;

use App\models\customers\Customer;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class CustomerPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any customers.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the customer.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\customers\Customer  $customer
     * @return mixed
     */
    public function view(User $user, Customer $customer)
    {
        //
        return $user->company->is($customer->company);

    }

    /**
     * Determine whether the user can create customers.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the customer.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\customers\Customer  $customer
     * @return mixed
     */
    public function update(User $user, Customer $customer)
    {
        //
        return $user->company->is($customer->company);

    }

    /**
     * Determine whether the user can delete the customer.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\customers\Customer  $customer
     * @return mixed
     */
    public function delete(User $user, Customer $customer)
    {
        //
        return $user->company->is($customer->company);

    }

    /**
     * Determine whether the user can restore the customer.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\customers\Customer  $customer
     * @return mixed
     */
    public function restore(User $user, Customer $customer)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the customer.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\customers\Customer  $customer
     * @return mixed
     */
    public function forceDelete(User $user, Customer $customer)
    {
        //
    }
}
