<?php
namespace App\Policies\provider;


use App\models\users\User;
use App\models\provider\Expense;
use Illuminate\Auth\Access\HandlesAuthorization;

class ExpensePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function view(User $user, Expense $expense)
    {
        return $expense->company->is($user->company);
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function update(User $user, Expense $expense)
    {
        //

        if (!$this->view($user,  $expense))
            return false;
        return !$expense->isValidated();
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function delete(User $user, Expense $expense)
    {
        //
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function restore(User $user, Expense $expense)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function forceDelete(User $user, Expense $expense)
    {
        //
    }
}
