<?php

namespace App\Policies\provider;

use App\models\provider\Purchase;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class PurchasePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\provider\Purchase  $purchase
     * @return mixed
     */
    public function view(User $user, Purchase $purchase)
    {
        return $purchase->company->is($user->company);
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\provider\Purchase  $purchase
     * @return mixed
     */
    public function update(User $user, Purchase $purchase)
    {
        if (!$this->view($user,  $purchase))
            return false;
        return !$purchase->isValidated();
    }



    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\provider\Purchase  $purchase
     * @return mixed
     */
    public function delete(User $user, Purchase $purchase)
    {
        //
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\provider\Purchase  $purchase
     * @return mixed
     */
    public function restore(User $user, Purchase $purchase)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\provider\Purchase  $purchase
     * @return mixed
     */
    public function forceDelete(User $user, Purchase $purchase)
    {
        //
    }
}
