<?php

namespace App\Policies\sales;

use App\models\users\Role;
use App\models\users\User;
use App\models\sales\Basic;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class BasicPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any basics.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the basic.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Basic  $basic
     * @return mixed
     */
    public function view(User $user, Basic $basic)
    {
        return $user->hasRole(Role::showBasicSale());
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::basic_sale());
    }




    /**
     * Determine whether the user can create basics.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function returnOrCreate(User $user)
    {
        return $user->can('manage-shifts') ? true :  $user->can('issue-basicsale');
    }

    public function create(User $user)
    {
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createBasicSale());
    }

    /**
     * Determine whether the user can update the basic.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Basic  $basic
     * @return mixed
     */
    public function update(User $user, Basic $basic)
    {
        return $user->is($basic->user);
    }

    /**
     * Determine whether the user can delete the basic.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Basic  $basic
     * @return mixed
     */
    public function delete(User $user, Basic $basic)
    {
        //
    }

    /**
     * Determine whether the user can restore the basic.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Basic  $basic
     * @return mixed
     */
    public function restore(User $user, Basic $basic)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the basic.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Basic  $basic
     * @return mixed
     */
    public function forceDelete(User $user, Basic $basic)
    {
        //
    }
}
