<?php

namespace App\Policies\sales;

use App\models\users\Role;
use App\models\users\User;
use App\models\sales\CashSale;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class CashSalePolicy
{
    use HandlesAuthorization;



    /**
     * Determine whether the user can view any cash sales.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the cash sale.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CashSale  $cashSale
     * @return mixed
     */

    public function view(User $user, CashSale $cashSale)
    {
        return $user->hasRole(Role::showCashSale());
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::cash_sale());
    }

    /**
     * Determine whether the user can create cash sales.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createCashSale());
    }



    /**
     * Determine whether the user can update the cash sale.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CashSale  $cashSale
     * @return mixed
     */


    public function update(User $user, CashSale $cashSale)
    {
        return $user->is($cashSale->user);
    }


    /**
     * Determine whether the user can delete the cash sale.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CashSale  $cashSale
     * @return mixed
     */
    public function delete(User $user, CashSale $cashSale)
    {
        //
    }

    /**
     * Determine whether the user can restore the cash sale.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CashSale  $cashSale
     * @return mixed
     */
    public function restore(User $user, CashSale $cashSale)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the cash sale.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CashSale  $cashSale
     * @return mixed
     */
    public function forceDelete(User $user, CashSale $cashSale)
    {
        //
    }
}