<?php

namespace App\Policies\sales;

use App\models\users\Role;
use App\models\users\User;
use App\models\sales\CreditNote;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class CreditNotePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any credit notes.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the credit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CreditNote  $creditNote
     * @return mixed
     */
    public function view(User $user, CreditNote $creditNote)
    {
        //
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::credit_note());
    }
    /**
     * Determine whether the user can create credit notes.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createCreditNote());
    }

    /**
     * Determine whether the user can update the credit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CreditNote  $creditNote
     * @return mixed
     */
    public function update(User $user, CreditNote $creditNote)
    {
        return $user->is($creditNote->user);
    }

    /**
     * Determine whether the user can delete the credit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CreditNote  $creditNote
     * @return mixed
     */
    public function delete(User $user, CreditNote $creditNote)
    {
        //
    }

    /**
     * Determine whether the user can restore the credit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CreditNote  $creditNote
     * @return mixed
     */
    public function restore(User $user, CreditNote $creditNote)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the credit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\CreditNote  $creditNote
     * @return mixed
     */
    public function forceDelete(User $user, CreditNote $creditNote)
    {
        //
    }
}
