<?php

namespace App\Policies\sales;

use App\models\users\Role;
use App\models\users\User;
use App\models\sales\DebitNote;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class DebitNotePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any debit notes.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the debit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\DebitNote  $debitNote
     * @return mixed
     */
    public function view(User $user, DebitNote $debitNote)
    {
        //
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::debit_note());
    }

    /**
     * Determine whether the user can create debit notes.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createDebitNote());
    }

    /**
     * Determine whether the user can update the debit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\DebitNote  $debitnote
     * @return mixed
     */
    public function update(User $user, DebitNote $debitnote)
    {
        return $user->is($debitnote->user);
    }

    /**
     * Determine whether the user can delete the debit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\DebitNote  $debitNote
     * @return mixed
     */
    public function delete(User $user, DebitNote $debitNote)
    {
        //
    }

    /**
     * Determine whether the user can restore the debit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\DebitNote  $debitNote
     * @return mixed
     */
    public function restore(User $user, DebitNote $debitNote)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the debit note.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\DebitNote  $debitNote
     * @return mixed
     */
    public function forceDelete(User $user, DebitNote $debitNote)
    {
        //
    }
}
