<?php

namespace App\Policies\sales;


use App\models\users\Role;
use App\models\users\User;
use App\models\sales\DeliveryNote;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class DeliveryNotePolicy
{
    use HandlesAuthorization;



    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\DeliveryNote  $DeliveryNote
     * @return mixed
     */
    public function view(User $user, DeliveryNote $DeliveryNote)
    {
        //
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::deliveryNote());
    }


    /**
     * Determine whether the user can create models.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createDeliveryNote());
    }



    /**
     * Determine whether the user can update the deliverynote.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\DeliveryNote  $deliverynote
     * @return mixed
     */
    public function update(User $user, DeliveryNote $deliverynote)
    {
        return $user->is($deliverynote->user);
    }
}
